# tests/test_pivot_params.py

import json
import pytest

def test_pivot_params():
    """
    Validate that the pivot_params.json file contains the expected values
    for the affine pivot function g(D) = a*D + b.
    """
    with open("data/pivot_params.json", "r") as f:
        params = json.load(f)

    # Expected calibration points: g(2.0) = 1.0 and g(2.20) = 0.73
    # Which yield a ≈ –1.35 and b ≈ 3.70
    assert pytest.approx(params["a"], rel=1e-3) == -1.35
    assert pytest.approx(params["b"], rel=1e-3) == 3.70
